@extends('backend.layouts.app')

@section('title', 'Profile')

@push('styles')

@endpush


@section('content')

    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li class="active"><i class="material-icons">library_books</i> Profile</li>
                            </ol>
    </div>

    <div class="block-header"></div>
            <div class="row clearfix">

                <div class="col-xs-12 col-sm-12">
                    <div class="card">
                        <div class="body">
                            <div>
                                <ul class="nav nav-tabs" role="tablist">
                                    <li role="presentation" class="active"><a href="#profile_settings" aria-controls="settings" role="tab" data-toggle="tab">Profile Settings</a></li>
                                    <li role="presentation"><a href="#change_password_settings" aria-controls="settings" role="tab" data-toggle="tab">Change Password</a></li>
                                </ul>

                                <div class="tab-content">

                                    <div role="tabpanel" class="tab-pane fade in active" id="profile_settings">
       
       <form action="{{route('admin.profile')}}" method="POST" enctype="multipart/form-data" class="form-horizontal">
                        @csrf

                        <div class="form-group form-float">
                             <label for="Email" class="col-sm-2 control-label">Name</label>
                            <div class="col-sm-10">
                            <div class="form-line">
                                <input type="text" name="name" class="form-control" value="{{ $profile ? $profile->name : "" }}">
                                <label class="form-label">Name</label>
                            </div>
                        </div>
                        </div>

                        <div class="form-group form-float">
                             <label for="Email" class="col-sm-2 control-label">Username</label>
                            <div class="col-sm-10">
                            <div class="form-line">
                                <input type="text" name="username" class="form-control" value="{{ $profile ? $profile->username : "" }}">
                                <label class="form-label">Username</label>
                            </div>
                        </div>
                        </div>

                        <div class="form-group form-float">
                             <label for="Email" class="col-sm-2 control-label">Email</label>
                            <div class="col-sm-10">
                            <div class="form-line">
                                <input type="email" name="email" class="form-control" value="{{ $profile ? $profile->email : "" }}">
                                <label class="form-label">Email</label>
                            </div>
                        </div>
                        </div>

                        <div class="form-group form-float">
                             <label for="Email" class="col-sm-2 control-label">Image</label>
                            <div class="col-sm-10">
                                
                            <input type="file" name="image" id="profile-image-input" style="display:none;">
                            <button type="button" class="btn bg-white btn-sm waves-effect m-t-15" id="profile-image-btn">
                                <i class="material-icons" style="color:black">image</i>
                                <span style="color:black">UPLOAD IMAGE</span>
                            </button><br><br>
                            <img src="{{asset('storage/admins/'.$profile->image)}}" id="profile-imgsrc" class="img-responsive" style="width:130px;height:130px;border-radius:65px">
                        
                        </div>
                        </div>


                                            <br><div class="form-group">
                                                <div class="col-sm-offset-2  col-sm-10">
                                                    <button type="submit" class="btn btn-block btn-indigo">SUBMIT</button>
                                                </div>
                                            </div>

                    </form>         
                                    </div>









                                    <div role="tabpanel" class="tab-pane fade in" id="change_password_settings">
                    <form action="{{route('admin.changepassword.update')}}" method="POST" class="form-horizontal">
                        @csrf

                        <div class="form-group form-float">
                            <label for="currentpassword" class="col-sm-3 control-label">Current Password</label>
                            <div class="col-sm-9">
                            <div class="form-line">
                                <input type="password" name="currentpassword" class="form-control"
                                value="{{old('currentpassword')}}">
                                <label class="form-label">Current Password</label>
                            </div>
                        </div>
                        </div>

                        <div class="form-group form-float">
                            <label for="newpassword" class="col-sm-3 control-label">New Password </label>
                            <div class="col-sm-9">
                            <div class="form-line">
                                <input type="password" name="newpassword" class="form-control" value="{{old('newpassword')}}">
                                <label class="form-label">New Password</label>
                            </div>
                        </div>
                        </div>

                        <div class="form-group form-float">
                            <label for="newpassword_confirmation" class="col-sm-3 control-label">Confirm New Password (Confirm)</label>
                            <div class="col-sm-9">
                            <div class="form-line">
                                <input type="password" name="newpassword_confirmation" class="form-control" value="{{old('newpassword_confirmation')}}">
                                <label class="form-label">Confirm New Password (Confirm)</label>
                            </div>
                        </div>
                        </div>
                                            <div class="form-group">
                                                <div class="col-sm-offset-3 col-sm-9">
                                                    <button type="submit" class="btn btn-block btn-indigo">SUBMIT</button>
                                                </div>
                                            </div>
                                      </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

@endsection


@push('scripts')

<script>
    $(function(){
        function showImage(fileInput,imgID){
            if (fileInput.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e){
                    $(imgID).attr('src',e.target.result);
                    $(imgID).attr('alt',fileInput.files[0].name);
                }
                reader.readAsDataURL(fileInput.files[0]);
            }
        }
        $('#profile-image-btn').on('click', function(){
            $('#profile-image-input').click();
        });
        $('#profile-image-input').on('change', function(){
            showImage(this, '#profile-imgsrc');
        });
    })
</script>

@endpush

