<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Agenda;
use App\Geosite;
use App\Event;

class AgendaController extends Controller
{
  



     public function index()
    {
        $agendas = Agenda::whereStatus(1)->orderBy('date_d', 'desc' )->get();
        $geosites=Geosite::whereStatus(1)->get();
        $events=Event::whereStatus(1)->orderBy('date_d', 'desc' )->limit(6)->get();
        
        return view('frontend.agendas.index',compact('agendas','geosites','events')); 

    }


   public function show($id,$slug)
    {   
    	$agenda=Agenda::findOrFail($id);
        return view('frontend.agendas.single', compact('agenda'));
    }


}
