<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Input;
use Carbon\Carbon;
use App\Product;
use App\Attrib;
use Session;
use DB;
use Validator;
use Toastr;
use Auth;

class ProductController extends Controller
{
  

    public function index()
    {
        $products = Product::latest()->get();

        return view('admin.products.index', compact('products'));
    }




    public function create()
    {
        return view('admin.products.create');
    }



    public function store(Request $request)
    {

        $this->validate($request, [
            'title'            => 'required|max:191',
            'image'            =>   'required|image|mimes:jpeg,jpg,png',
            // 'style'            => 'required',
        ]);


        $image = $request->file('image');
        $slug  = Str::slug($request->title);
        $imageName = "";
        //upload image
        if (isset($image)) {

            //cree folder depliants
            if (!Storage::disk('public')->exists('products')) {
                Storage::disk('public')->makeDirectory('products');
            }
                $currentDate = Carbon::now()->toDateString();
                $imageName = $slug. '-' .$currentDate . '-' . uniqid() . '.' . $image->getClientOriginalExtension();

                  $img = Image::make($image->getRealPath());
                 $img->stream();
                Storage::disk('local')->put('public/products/' . $imageName, $img);
        } else {
            $imageName = "default.png";
        }


        $product = new Product();
        $product->admin_id =Auth::id();
        $product->title = $request->title;
        $product->slug = $slug;
        $product->image = $imageName;
        $product->description = $request->description;
        $product->style = $request->style;
        $product->status = $request->has('status') ? 1 : 0;
        $product->save();

        Toastr::success('message', 'Products created successfully.'); 
        return redirect()->route('admin.product.index');
    }




    public function edit($id)
    {
        $product = Product::findOrFail($id);
            return view('admin.products.edit', compact('product'));
    }



    public function update(Request $request, $id)
    {


        $this->validate($request, [
            'title'            => 'required|max:191',
            // 'style'            => 'required',
        ]);

        $product =Product::findOrFail($id);
        $image = $request->file('image');
        $slug  = Str::slug($request->title);
        $imageName = "";
        //upload image
        if (isset($image)) {

            //cree folder depliants
            if (!Storage::disk('public')->exists('products')) {
                Storage::disk('public')->makeDirectory('products');}

                // delete old image
            if(Storage::disk('public')->exists('products/'.$product->image)){
                Storage::disk('public')->delete('products/'.$product->image); }
            
                $currentDate = Carbon::now()->toDateString();
                $imageName = $slug. '-' .$currentDate . '-' . uniqid() . '.' . $image->getClientOriginalExtension();

                  $img = Image::make($image->getRealPath());
                 $img->stream();
                Storage::disk('local')->put('public/products/' . $imageName, $img);
        } else {
            $imageName =$product->image;
        }


        
        $product->admin_id =Auth::id();
        $product->title = $request->title;
        $product->slug = $slug;
        $product->image = $imageName;
        $product->style = $request->style;
        $product->description = $request->description;
        $product->status = $request->has('status') ? 1 : 0;
        $product->save();

        Toastr::success('message', 'depliant updated successfully.'); 
        return redirect()->route('admin.product.index');

    }





    public function destroy($id)
    {
        $product = Product::findOrFail($id);
          
        //deleted attrib
        Attrib::where('product_id',$product->id)->delete();
        //delete images
         if(Storage::disk('public')->exists('products/'.$product->image)){
                Storage::disk('public')->delete('products/'.$product->image); }
            
        // DB::table('geosites_translations')->where('geosite_id',$id)->delete();
         
        $product->delete();

        Toastr::success('message', 'product deleted successfully.'); 
        return redirect()->route('admin.product.index');
    }



    public function enable($id) {

        $product = Product::findOrFail($id);
            if ($product->status == 1)          
            { Geosite::where('id', $id)->update(['status' => 0]);
            Toastr::success('message', 'élement invisible.'); }
            else
            { Geosite::where('id', $id)->update(['status' => 1]);
            Toastr::success('message', 'élement visible.'); }
          
          return redirect()->route('admin.product.index');
    }




}
